@extends('update.master')

@section('content')

<section>
   
    <div class="card p-4">
        <div class="card-body">
            <div class="row">
                <div class="mb-5 p-4 text-center  d-flex  align-items-center justify-content-center flex-column position-relative gap-2">
                    <div class="update-logo">
                        <img src="{{showImage("assets/file/default/xsender.png")}}" alt="{{translate('Site Logo')}}">
                    </div>
                    <h6 class="text-dark version-text">{{translate("See what our latest ")}} <span>{{ $new_version  }}</span> {{translate("version has to offer")}}</h6>
                </div> 
            </div>
            <div class="row gx-0 gy-5 update-content">
                
                @foreach($file_contents as $key => $value)
                
                    <div class="{{count($file_contents) >= 3 ? 'col-xl-4' : (count($file_contents) == 2 ? 'col-xl-6' : 'col-xl-12')}} col-12 update_info">
                    <h5> 
                        <span>
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 34 34">
                            <path d="M16.8838 8.49452C16.6874 8.50021 16.5138 8.62306 16.4436 8.80615L16.0205 9.90897C15.9498 10.0925 15.9973 10.3008 16.14 10.436L17.2006 11.4401C17.1902 11.691 17.1973 11.9386 17.222 12.1815L16.214 13.243C16.0789 13.3853 16.0428 13.5955 16.123 13.7752L16.6044 14.8562C16.6822 15.0317 16.8563 15.1442 17.0479 15.1442C17.0522 15.1442 17.0565 15.1442 17.0612 15.1442L18.5245 15.1043C18.6886 15.2846 18.8679 15.4558 19.0614 15.6152L19.0989 17.0756C19.1041 17.2725 19.227 17.4466 19.4106 17.5168L20.5134 17.9399C20.5703 17.9617 20.6291 17.9721 20.6875 17.9721C20.8184 17.9721 20.9464 17.919 21.0399 17.8203L22.045 16.7597C22.2912 16.7711 22.5402 16.7645 22.7864 16.7412L23.8479 17.7468C23.9902 17.881 24.2003 17.918 24.3796 17.8374L25.4606 17.356C25.6399 17.2763 25.7533 17.096 25.7486 16.8997L25.7101 15.4382C25.8913 15.2708 26.0621 15.0901 26.22 14.8989L27.6805 14.861C27.8769 14.8558 28.051 14.7329 28.1212 14.5493L28.5443 13.447C28.6149 13.2634 28.5675 13.0557 28.4247 12.9205L27.3641 11.9154C27.3746 11.6645 27.3674 11.4169 27.3428 11.174L28.3507 10.1125C28.4864 9.97016 28.5224 9.76003 28.4423 9.58026L27.9604 8.49926C27.8821 8.32376 27.708 8.21134 27.5169 8.21134C27.5126 8.21134 27.5083 8.21134 27.5036 8.21134L26.0403 8.25119C25.8757 8.07047 25.6964 7.89971 25.5033 7.74033L25.4659 6.27987C25.4606 6.08302 25.3378 5.90894 25.1542 5.83874L24.0514 5.41564C23.8669 5.34449 23.6596 5.39192 23.5249 5.5347L22.516 6.5972C22.2746 6.58724 22.0293 6.59482 21.7851 6.61949L20.7169 5.60869C20.5741 5.47398 20.3644 5.43746 20.1851 5.51809L19.1041 5.99954C18.9248 6.07923 18.8115 6.259 18.8162 6.45537L18.8537 7.92627C18.6715 8.09181 18.5027 8.26826 18.3485 8.45467L16.8838 8.49452ZM18.9794 9.22451C19.171 8.96695 19.3982 8.72931 19.6544 8.51823C19.7691 8.42337 19.8346 8.28059 19.8308 8.13118L19.7957 6.75467L20.2843 6.53696L21.2842 7.48325C21.3933 7.58618 21.546 7.63171 21.6902 7.61084C22.0179 7.56104 22.3471 7.55013 22.6668 7.58096C22.8139 7.59708 22.9614 7.53969 23.0638 7.43154L24.0063 6.43877L24.503 6.62945L24.5381 7.9922C24.5419 8.14019 24.613 8.27822 24.7306 8.3674C25.0015 8.57231 25.2434 8.80283 25.4493 9.05233C25.5446 9.16759 25.6902 9.23447 25.8373 9.22878L27.2052 9.19131L27.4229 9.67892L26.4804 10.6717C26.377 10.7803 26.3296 10.9302 26.3519 11.0782C26.3998 11.3974 26.4098 11.7313 26.3813 12.071C26.3685 12.218 26.424 12.3627 26.5312 12.4642L27.5211 13.4019L27.3304 13.8981L25.9672 13.9337C25.8197 13.9375 25.6817 14.0086 25.5925 14.1262C25.39 14.3942 25.1585 14.639 24.9047 14.8543C24.7923 14.9492 24.7292 15.0906 24.733 15.2376L24.7686 16.6008L24.2805 16.8181L23.2901 15.8803C23.1834 15.7793 23.0354 15.7323 22.8907 15.7518C22.5601 15.7968 22.2243 15.8049 21.8894 15.7769C21.7433 15.7617 21.5977 15.8196 21.4962 15.9268L20.5584 16.9167L20.0618 16.726L20.0267 15.3633C20.0229 15.2153 19.9518 15.0773 19.8341 14.9881C19.5623 14.7827 19.3204 14.5522 19.1155 14.3036C19.0211 14.1884 18.8803 14.1329 18.7275 14.1267L17.3596 14.1642L17.1423 13.6766L18.0848 12.6838C18.1877 12.5752 18.2352 12.4253 18.2129 12.2773C18.165 11.9581 18.155 11.6241 18.1835 11.2845C18.1963 11.1375 18.1408 10.9928 18.0336 10.8908L17.0436 9.95356L17.2343 9.45693L18.6032 9.41994C18.7517 9.41567 18.8907 9.34357 18.9794 9.22451ZM5.64217 20.22C5.46097 20.2954 5.34286 20.4723 5.34286 20.6687V22.0096C5.34286 22.206 5.46097 22.3829 5.64217 22.4583L7.20935 23.1091C7.29995 23.3909 7.41142 23.6627 7.54186 23.9216L6.8963 25.4836C6.82088 25.6648 6.86262 25.874 7.0016 26.0125L7.94789 26.9583C8.08734 27.0978 8.29605 27.1385 8.47724 27.0636L10.0335 26.418C10.302 26.5532 10.5776 26.6666 10.8565 26.7567L11.502 28.3168C11.577 28.4985 11.7544 28.617 11.9508 28.617H13.2917C13.4881 28.617 13.6655 28.4985 13.7404 28.3168L14.386 26.7567C14.6644 26.6661 14.94 26.5527 15.2089 26.418L16.7652 27.0636C16.9469 27.1381 17.1551 27.0978 17.2946 26.9583L18.2409 26.0125C18.3798 25.8735 18.4216 25.6643 18.3462 25.4831L17.7001 23.9264C17.8334 23.6612 17.9482 23.3861 18.0421 23.1044L19.5998 22.4583C19.7815 22.3829 19.8996 22.206 19.8996 22.0096V20.6687C19.8996 20.4723 19.7815 20.2954 19.5998 20.22L18.0421 19.5735C17.9482 19.2917 17.8334 19.0166 17.7001 18.7514L18.3462 17.1956C18.4216 17.014 18.3798 16.8048 18.2409 16.6658L17.2946 15.7195C17.1556 15.5805 16.9469 15.5407 16.7652 15.6142L15.2085 16.2598C14.939 16.1246 14.6639 16.0112 14.386 15.9211L13.7404 14.361C13.6655 14.1794 13.4881 14.0608 13.2917 14.0608H11.9508C11.7544 14.0608 11.577 14.1794 11.502 14.361L10.8565 15.9211C10.5785 16.0112 10.3029 16.1246 10.034 16.2598L8.47724 15.6142C8.29557 15.5402 8.08687 15.5805 7.94789 15.7195L7.0016 16.6658C6.86262 16.8048 6.82135 17.0135 6.8963 17.1947L7.54186 18.7562C7.41142 19.0152 7.29995 19.2874 7.20935 19.5692L5.64217 20.22ZM7.79468 20.3779C7.93271 20.3205 8.03659 20.2029 8.07643 20.0587C8.17841 19.6906 8.32166 19.341 8.50191 19.0204C8.57495 18.8904 8.58396 18.7344 8.52704 18.5968L7.918 17.1235L8.40514 16.6359L9.87225 17.2445C10.0089 17.3009 10.164 17.2919 10.2925 17.2212C10.635 17.0325 10.9898 16.8864 11.3469 16.7877C11.4911 16.7479 11.6092 16.6435 11.6662 16.505L12.2757 15.0322H12.9668L13.5763 16.505C13.6332 16.6435 13.7508 16.7474 13.895 16.7877C14.2517 16.8864 14.607 17.0325 14.95 17.2212C15.0799 17.2919 15.2341 17.3009 15.3702 17.2445L16.8373 16.6359L17.3244 17.1231L16.7154 18.5897C16.659 18.7263 16.6675 18.8814 16.7391 19.0109C16.9241 19.3462 17.0726 19.7029 17.1803 20.0715C17.2215 20.2128 17.3244 20.3276 17.4606 20.3841L18.9282 20.9931V21.6852L17.4606 22.2937C17.3244 22.3502 17.2215 22.465 17.1803 22.6063C17.0726 22.9749 16.9241 23.3316 16.7391 23.6669C16.6675 23.7964 16.659 23.9515 16.7154 24.0877L17.3244 25.5552L16.8373 26.0419L15.3702 25.4333C15.2341 25.3769 15.079 25.3854 14.9495 25.4566C14.6084 25.6449 14.2536 25.791 13.895 25.8901C13.7508 25.9304 13.6332 26.0343 13.5763 26.1728L12.9668 27.6456H12.2757L11.6662 26.1728C11.6092 26.0343 11.4911 25.93 11.3469 25.8901C10.9883 25.791 10.6335 25.6449 10.293 25.457C10.164 25.3854 10.0089 25.3769 9.87225 25.4333L8.40514 26.0419L7.918 25.5548L8.52704 24.081C8.58396 23.9435 8.57495 23.7874 8.50191 23.6574C8.32166 23.3368 8.17841 22.9877 8.07643 22.6191C8.03659 22.4754 7.93271 22.3578 7.79468 22.3004L6.31429 21.6856V20.9926L7.79468 20.3779ZM28.3574 23.1912L27.5003 22.8359C27.4571 22.7149 27.4073 22.5959 27.3523 22.4797L27.7075 21.6235C27.783 21.4423 27.7412 21.2331 27.6022 21.0942L27.0326 20.5245C26.8936 20.3855 26.6839 20.3452 26.5032 20.4192L25.6466 20.7745C25.5294 20.719 25.4104 20.6701 25.2904 20.6274L24.9356 19.7698C24.8606 19.5882 24.6832 19.4696 24.4868 19.4696H23.68C23.4836 19.4696 23.3062 19.5882 23.2313 19.7694L22.876 20.6279C22.756 20.6701 22.6369 20.719 22.5198 20.7745L21.6631 20.4192C21.482 20.3447 21.2732 20.385 21.1338 20.5245L20.5646 21.0942C20.4256 21.2331 20.3844 21.4418 20.4593 21.623L20.8146 22.4825C20.7605 22.5964 20.7126 22.7135 20.6709 22.8335L19.809 23.1912C19.6278 23.2666 19.5097 23.4435 19.5097 23.6399V24.4472C19.5097 24.6436 19.6278 24.8205 19.809 24.8959L20.6709 25.2536C20.7126 25.3736 20.7605 25.4907 20.8146 25.6046L20.4593 26.4641C20.3844 26.6452 20.4256 26.8539 20.5646 26.9929L21.1338 27.5621C21.2732 27.7016 21.4834 27.7419 21.6631 27.6674L22.5193 27.3122C22.6365 27.3676 22.7555 27.4165 22.876 27.4592L23.2313 28.3173C23.3062 28.4985 23.4836 28.617 23.68 28.617H24.4868C24.6832 28.617 24.8606 28.4985 24.9356 28.3168L25.2904 27.4592C25.4108 27.417 25.5299 27.3676 25.6471 27.3122L26.5032 27.6674C26.6849 27.7419 26.8931 27.7011 27.0326 27.5621L27.6022 26.9929C27.7412 26.8539 27.783 26.6452 27.7075 26.4636L27.3523 25.6074C27.4073 25.4912 27.4571 25.3721 27.5003 25.2512L28.3574 24.8959C28.539 24.8205 28.6572 24.6436 28.6572 24.4472V23.6399C28.6572 23.4435 28.539 23.2666 28.3574 23.1912ZM27.6857 24.1228L26.9221 24.4396C26.7859 24.4961 26.683 24.6108 26.6417 24.7522C26.581 24.9595 26.4975 25.1611 26.3922 25.3517C26.3211 25.4812 26.3125 25.6359 26.369 25.772L26.6858 26.5357L26.5753 26.6457L25.8116 26.3289C25.675 26.2724 25.5204 26.281 25.3904 26.3526C25.1998 26.4584 25.0005 26.5399 24.7985 26.5959C24.6543 26.6358 24.5362 26.7401 24.4792 26.8786L24.1619 27.6456H24.0044L23.6871 26.8781C23.6302 26.7401 23.5121 26.6358 23.3679 26.5959C23.1663 26.5399 22.9671 26.4584 22.7755 26.3521C22.6455 26.281 22.4913 26.2724 22.3547 26.3289L21.5911 26.6457L21.4805 26.5352L21.7979 25.7677C21.8548 25.6302 21.8458 25.4746 21.7727 25.3446C21.6717 25.1644 21.5915 24.9685 21.5346 24.7626C21.4948 24.6184 21.3909 24.5008 21.2529 24.4434L20.4811 24.1232V23.9639L21.2529 23.6437C21.3909 23.5863 21.4948 23.4687 21.5346 23.3245C21.5915 23.1186 21.6717 22.9227 21.7727 22.7425C21.8458 22.6125 21.8548 22.4569 21.7979 22.3194L21.4805 21.5514L21.5911 21.4409L22.3547 21.7577C22.4909 21.8137 22.645 21.8052 22.7745 21.7345C22.9685 21.6283 23.1682 21.5462 23.3679 21.4907C23.5121 21.4509 23.6302 21.3465 23.6871 21.2085L24.0044 20.441H24.1619L24.4792 21.208C24.5362 21.3465 24.6543 21.4509 24.7985 21.4907C24.9986 21.5462 25.1983 21.6283 25.3914 21.7345C25.5204 21.8052 25.675 21.8137 25.8116 21.7577L26.5753 21.4409L26.6858 21.5514L26.369 22.3151C26.3125 22.4512 26.3211 22.6058 26.3922 22.7353C26.4975 22.926 26.581 23.1276 26.6417 23.3349C26.683 23.4762 26.7859 23.591 26.9221 23.6475L27.6857 23.9643V24.1228Z"   />
                            <path d="M22.2831 14.251C23.7023 14.251 24.8573 13.096 24.8573 11.6768C24.8573 10.2576 23.7023 9.1026 22.2831 9.1026C20.8634 9.1026 19.7084 10.2576 19.7084 11.6768C19.7084 13.096 20.8634 14.251 22.2831 14.251ZM22.2831 10.074C23.1668 10.074 23.8859 10.7931 23.8859 11.6768C23.8859 12.5605 23.1668 13.2796 22.2831 13.2796C21.3989 13.2796 20.6799 12.5605 20.6799 11.6768C20.6799 10.7931 21.3989 10.074 22.2831 10.074ZM12.6219 24.1939C14.1939 24.1939 15.4731 22.9127 15.4731 21.338C15.4731 19.766 14.1939 18.4868 12.6219 18.4868C11.0472 18.4868 9.76599 19.766 9.76599 21.338C9.76599 22.9127 11.0472 24.1939 12.6219 24.1939ZM12.6219 19.4582C13.6583 19.4582 14.5017 20.3015 14.5017 21.338C14.5017 22.3772 13.6583 23.2225 12.6219 23.2225C11.5827 23.2225 10.7374 22.3772 10.7374 21.338C10.7374 20.3015 11.5827 19.4582 12.6219 19.4582ZM24.0851 22.4697C23.2147 22.4697 22.5065 23.1755 22.5065 24.0431C22.5065 24.9111 23.2147 25.6169 24.0851 25.6169C24.9526 25.6169 25.6584 24.9111 25.6584 24.0431C25.6584 23.1755 24.9526 22.4697 24.0851 22.4697ZM24.0851 24.6455C23.7502 24.6455 23.4779 24.3751 23.4779 24.0431C23.4779 23.711 23.7502 23.4411 24.0851 23.4411C24.4114 23.4411 24.687 23.7167 24.687 24.0431C24.687 24.3694 24.4114 24.6455 24.0851 24.6455Z"   />
                            </svg>
                        </span>
                        {{$key}}
                    </h5>
                    <ul class="d-flex flex-column  gap-3 mt-4 update-list">
                        @foreach (explode("\n", $value) as $item) 
                            
                            <li class="gap-2">
                                <i class="lar la-check-circle fs-4 "></i>
                                <p>{{$item}}</p>
                            </li>
                        @endforeach
                    </ul>
                </div>
                @endforeach
                    
                <div>
                    <p class="text-danger fs-6 fw-bold text-center">{{ translate("Please, Turn off Cron Jobs and Node Application before proceeding to update.") }}</p>
                    <p class="text-danger fs-6 fw-bold text-center">{{ translate("Do not close this window while updating!") }}</p>
                </div>
                
            </div>
        </div>
    </div>
    <div class="row">
        <div class="d-flex align-items-center justify-content-center text-end mt-5">
            <a class="i-btn warning--btn text-dark update-btn" href="{{route('admin.update.version')}}"> <i class="las la-cogs"></i> {{translate('Update Now')}}</a>
        </div>
    </div>
</section>
@endsection

@push('script-push')
<script>
	(function($){
		"use strict";
        $(document).ready(function(){
          
            $(".update-btn").click(function(){
            
                $(".update-btn").addClass("updating");
            });
        });
    })(jQuery);
</script>
@endpush