<div class="col-span-12 lg:col-span-6 mt-8">
                <div class="intro-y block sm:flex items-center h-10">
                    <h2 class="text-lg font-medium truncate mr-5">Sent SMS Report</h2>
                  
                </div>
                <div class="intro-y box p-5 mt-12 sm:mt-5">
                    <div class="flex flex-col xl:flex-row xl:items-center">
                        <div class="flex">
                            <div>
                                <div class="text-theme-20 dark:text-gray-300 text-lg xl:text-xl font-bold text-center"><?php echo e(number_format(sentSMSCurrentMonthData())); ?></div>
                                <div class="text-gray-600 dark:text-gray-600">This Month</div>
                            </div>
                            <div class="w-px h-12 border border-r border-dashed border-gray-300 dark:border-dark-5 mx-4 xl:mx-6"></div>
                            <div>
                                <div class="text-gray-600 dark:text-gray-600 text-lg xl:text-xl font-medium text-center"><?php echo e(number_format(sentSMSLastMonthData())); ?></div>
                                <div class="text-gray-600 dark:text-gray-600">Last Month</div>
                            </div>
                        </div>
                     
                    </div>

                    <div>
                        <div id="sent_sms_chart"></div>
                    </div>
                </div>
            </div>

            <script src="<?php echo e(filePath('assets/js/apexcharts.js')); ?>"></script>
            <script>

                // This is dynmic script, all the datas are coming from laravel query


                "use strict"
                
               var options = {
          series: [{
          name: 'Twilio',
          data: [
              <?php $__currentLoopData = sentSMSMonthWiseCurrentYearDataTwilio(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sent_sms_twilio): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <?php echo e($sent_sms_twilio->count); ?>,
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          ]
        }, {
          name: 'Nexmo',
          data: [
              <?php $__currentLoopData = sentSMSMonthWiseCurrentYearDataNexmo(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sent_sms_nexmo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <?php echo e($sent_sms_nexmo->count); ?>,
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          ]
        }, {
          name: 'Plivo',
          data: [
              <?php $__currentLoopData = sentSMSMonthWiseCurrentYearDataPlivo(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sent_sms_plivo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <?php echo e($sent_sms_plivo->count); ?>,
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          ]
        }],
          chart: {
          type: 'area',
          height: 350
        },
        plotOptions: {
          bar: {
            horizontal: false,
            columnWidth: '55%',
            endingShape: 'rounded'
          },
        },
        dataLabels: {
          enabled: false
        },
        stroke: {
          show: true,
          width: 2,
          colors: ['transparent']
        },
        xaxis: {
          categories: [
            <?php $__currentLoopData = sentSMSMonthWiseCurrentYearData(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $monthly_sent_sms): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              '<?php echo e($monthly_sent_sms->monthname); ?>',
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          ],
        },
        yaxis: {
          title: {
            text: 'Total SMS Sent'
          }
        },
        fill: {
          opacity: 1
        },
        tooltip: {
          y: {
            formatter: function (val) {
              return val
            }
          }
        }
        };

        var chart = new ApexCharts(document.querySelector("#sent_sms_chart"), options);
        chart.render();
    
            </script><?php /**PATH /home/tanbir/office/maildoll/resources/views/dashboard/components/sent_sms_chart.blade.php ENDPATH**/ ?>