<div class="col-span-12 lg:col-span-6 mt-8">
                <div class="intro-y block sm:flex items-center h-10">
                    <h2 class="text-lg font-medium truncate mr-5">Sent Mail Report</h2>
                   
                </div>
                <div class="intro-y box p-5 mt-12 sm:mt-5">
                    <div class="flex flex-col xl:flex-row xl:items-center">
                        <div class="flex">
                            <div>
                                <div class="text-theme-20 dark:text-gray-300 text-lg xl:text-xl font-bold text-center"><?php echo e(number_format(sentMailCurrentMonthData())); ?></div>
                                <div class="text-gray-600 dark:text-gray-600">This Month</div>
                            </div>
                            <div class="w-px h-12 border border-r border-dashed border-gray-300 dark:border-dark-5 mx-4 xl:mx-6"></div>
                            <div>
                                <div class="text-gray-600 dark:text-gray-600 text-lg xl:text-xl font-medium text-center"><?php echo e(number_format(sentMailLastMonthData())); ?></div>
                                <div class="text-gray-600 dark:text-gray-600">Last Month</div>
                            </div>
                        </div>
                     
                    </div>

                    <div>
                        <div id="my-chart-1"></div>
                    </div>
                </div>
            </div>

            <script src="<?php echo e(filePath('assets/js/apexcharts.js')); ?>"></script>
            <script>

                // This is dynmic script, all the datas are coming from laravel query

                "use strict"
                var options = {
          series: [{
            name: "Sent Mails",
            data: [
              <?php $__currentLoopData = sentMailMonthWiseCurrentYearData(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sent_mail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <?php echo e($sent_mail->count); ?>,
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              ]
        }],
          chart: {
          height: 350,
          type: 'area',
          zoom: {
            enabled: true
          }
        },
        dataLabels: {
          enabled: false
        },
        stroke: {
          curve: 'smooth'
        },
        title: {
          text: 'Sent Mails By Month',
          align: 'left'
        },
        grid: {
          row: {
            colors: ['#f3f3f3', 'transparent'], // takes an array which will be repeated on columns
            opacity: 0.5
          },
        },
        xaxis: {
          categories: [
            <?php $__currentLoopData = sentMailMonthWiseCurrentYearData(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $monthly_sent_mail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              '<?php echo e($monthly_sent_mail->monthname); ?>',
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            ],
        }
        };

        var chart = new ApexCharts(document.querySelector("#my-chart-1"), options);
        chart.render();

        

    
            </script><?php /**PATH /home/tanbir/office/maildoll/resources/views/dashboard/components/sent_mails_chart.blade.php ENDPATH**/ ?>