<?php $__env->startSection('head'); ?>
    <title>Login - <?php echo e(orgName()); ?></title>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="container sm:px-10">
        <div class="xl:grid grid-cols-2 gap-4">
            <!-- BEGIN: Login Info -->
            <div class="flex-col min-h-screen hidden sm:hidden md:flex lg:flex xl:flex">
                <a href="<?php echo e(route('frontend.index')); ?>" class="-intro-x flex items-center pt-5 w-48">
                    <img alt="<?php echo e(orgName()); ?>" src="<?php echo e(logo()); ?>">

                </a>
                <div class="my-auto">
                    <img alt="<?php echo e(orgName()); ?>" class="-intro-x w-1/2 -mt-16" src="<?php echo e(getImageForAuth('login')); ?>">
                    <div class="-intro-x text-white font-medium text-4xl leading-tight mt-10">A few more clicks to <br>
                        Sign in to your account.</div>
                </div>
            </div>
            <!-- END: Login Info -->
            <!-- BEGIN: Login Form -->
            <div class="h-screen xl:h-auto flex py-5 xl:py-0 my-10 mx-10 xl:my-0">
                <div
                    class="my-auto ml-3 mx-auto xl:ml-20 bg-white xl:bg-transparent px-5 sm:px-8 py-8 xl:p-0 rounded-md shadow-md xl:shadow-none w-full sm:w-3/4 lg:w-2/4 xl:w-auto">


                    <?php if(env('DEMO_ACTIVE') == 'YES'): ?>
                        <div class="mt-5 m-auto xl:mt-8 text-center">
                            <button class="button button--lg w-1/4 text-white bg-theme-1 xl:mr-3 align-top tooltip"
                                title="Login as admin" onclick="admin()"> Admin </button>
                            <button class="button button--lg w-2/4 text-white bg-theme-1 xl:mr-3 align-top tooltip"
                                title="Login as customer" onclick="customer()"> Customer </button>
                            <table class="table mt-4 w-full m-auto">
                                <thead>
                                    <tr>
                                        <th class="border border-b-2 dark:border-dark-5 whitespace-nowrap">Email</th>
                                        <th class="border border-b-2 dark:border-dark-5 whitespace-nowrap">Password</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr class="hover:bg-gray-200">
                                        <td class="border">admin@mail.com</td>
                                        <td class="border">12345678</td>
                                    </tr>
                                    <tr class="hover:bg-gray-200">
                                        <td class="border">customer@mail.com</td>
                                        <td class="border">12345678</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    <?php endif; ?>

                    <a href="<?php echo e(route('frontend.index')); ?>"
                        class="-intro-x md:invisible flex items-center pt-5 w-48 m-auto mb-5">
                        <img alt="<?php echo e(orgName()); ?>" src="<?php echo e(logo()); ?>">
                    </a>


                    <h2 class="intro-x font-bold text-2xl xl:text-3xl text-center xl:text-left">Sign In</h2>

                    <form action="<?php echo e(route('login')); ?>" method="post">
                        <?php echo csrf_field(); ?>
                        <div class="intro-x mt-2 text-gray-500 xl:hidden text-center">A few more clicks to sign in to your account.</div>
                        <div class="intro-x mt-8">
                            <div id="login-form">
                                <input type="email" name="email" id="input-email"
                                    class="intro-x login__input input w-full input--lg border border-gray-300 "
                                    placeholder="Enter Email" value="" data-parsley-type="email"
                                    data-parsley-required>
                                <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div id="error-email" class="login__input-error w-5/6 text-theme-6 mt-2">
                                        <?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                <input type="password" name="password" id="input-password"
                                    class="intro-x login__input input w-full input--lg border border-gray-300 block mt-4"
                                    placeholder="Enter Password" value="" data-parsley-required>
                                <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div id="error-email" class="login__input-error w-5/6 text-theme-6 mt-2">
                                        <?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        <div class="intro-x flex text-gray-700 dark:text-gray-600 text-xs sm:text-sm mt-4">
                            <div class="flex items-center mr-auto">
                                <input type="checkbox" name="remember" class="input border mr-2" id="input-remember-me">
                                <label class="cursor-pointer select-none" for="input-remember-me">Remember me</label>
                            </div>
                            <a href="<?php echo e(route('password.request')); ?>">Forgot Password?</a>
                        </div>
                        <div class="intro-x mt-5 xl:mt-8 text-center xl:text-left">
                            <button id="btn-login"
                                class="button button--lg w-full xl:w-32 text-white bg-theme-1 xl:mr-3 align-top">Login</button>
                            <button type="button" onclick="location.replace('/register')"
                                class="button button--lg w-full xl:w-32 text-gray-700 border border-gray-300 dark:border-dark-5 dark:text-gray-300 mt-3 xl:mt-0 align-top"
                                id="btn-signup">Sign up</button>
                        </div>
                    </form>



                </div>
            </div>
            <!-- END: Login Form -->
        </div>
    </div>


    <input type="hidden" value="<?php echo e(route('register')); ?>" id="signup_url">
    <input type="hidden" value="<?php echo e(route('dashboard')); ?>" id="dashboard_url">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    
    <script src="<?php echo e(filePath('assets/js/jquery.js')); ?>"></script>
    <script src="<?php echo e(filePath('assets/js/parsley.js')); ?>"></script>
    <script src="<?php echo e(filePath('assets/js/validation.js')); ?>"></script>

    <?php if(env('DEMO_ACTIVE') == 'YES'): ?>
        <script src="<?php echo e(filePath('bladejs/demo.js')); ?>"></script>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('../layout/login', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/tanbir/office/maildoll/resources/views/auth/login/main.blade.php ENDPATH**/ ?>