<!-- BEGIN: Top Bar -->
<?php if(auth()->guard()->check()): ?>
    <div class="top-bar">
        <!-- BEGIN: Breadcrumb -->
        <div class="-intro-x breadcrumb mr-auto hidden sm:flex">
            <a href="<?php echo e(route('dashboard')); ?>" class="">Dashboard</a>

            <i data-feather="chevron-right" class="breadcrumb__icon"></i>


            <?php for($i = 1; $i <= count(Request::segments()); $i++): ?>
                <?php echo e(ucfirst(Request::segment($i))); ?>


                <?php if($i + 1 == count(Request::segments())): ?>
                    <i data-feather="chevron-right" class="breadcrumb__icon"></i>
                <?php endif; ?>
            <?php endfor; ?>

        </div>
        <!-- END: Breadcrumb -->

        <!-- BEGIN: Frontend -->
        <div class="intro-x relative mr-3 sm:mr-6">
            <a href="<?php echo e(route('frontend.index')); ?>" target="_blank"
                class="button px-2 mr-1 mb-2 border text-gray-700 dark:bg-dark-5 dark:text-gray-300 tooltip inline-block"
                title="Go To Frontend">
                <span class="w-5 h-5 flex items-center justify-center"> <i data-feather="sun" class="w-4 h-4"></i> </span>
            </a>
        </div>
        <!-- END: Frontend -->

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Admin')): ?>
            <?php if(env('NEEDS_MIGRATION', 'true')): ?>
                <!-- BEGIN: finishing update -->
                <div class="intro-x relative mr-3 sm:mr-6 blinking">
                    <a href="/finalizing-update"
                        class="button px-2 mr-1 mb-2 border text-gray-700 dark:bg-dark-5 dark:text-gray-300 tooltip inline-block"
                        title="Finalizing Update">
                        <span class="w-5 h-5 flex items-center justify-center">
                            <img src="https://api.iconify.design/mdi:cloud-sync-outline.svg?color=%23858585" alt="">
                        </span>
                    </a>
                </div>
                <!-- END: finishing update -->
            <?php endif; ?>
            <!-- BEGIN: queue retry -->
            <div class="intro-x relative mr-3 sm:mr-6 blinking">
                <a href="javascript:;" onclick="queueRetry()"
                    class="button <?php echo e(CheckFailedJob()); ?> px-2 mr-1 mb-2 border text-gray-700 dark:bg-dark-5 dark:text-gray-300 tooltip inline-block"
                    title="Queue Retry">
                    <span class="w-5 h-5 flex items-center justify-center"> <i data-feather="radio"
                            class="w-4 h-4 queue-retry-loader"></i> </span>
                </a>
            </div>
            <!-- END: queue retry -->

            <!-- BEGIN: queue retry -->
            <div class="intro-x relative mr-3 sm:mr-6 blinking ">
                <a href="javascript:;" onclick="queueWork()"
                    class="button px-2 <?php echo e(CheckQueue()); ?> mr-1 mb-2 border text-gray-700 dark:bg-dark-5 dark:text-gray-300 tooltip inline-block"
                    title="Restart Queue">
                    <span class="w-5 h-5 flex items-center justify-center"> <i data-feather="refresh-ccw"
                            class="w-4 h-4 queue-work-loader"></i> </span>
                </a>
            </div>
            <!-- END: queue retry -->
        <?php endif; ?>


        <!-- BEGIN: Currency -->
        <div class="intro-x relative mr-3 sm:mr-6">

            <div class="dropdown">

                <button
                    class="dropdown-toggle button px-2 mr-1 mb-2 border text-gray-700 dark:bg-dark-5 dark:text-gray-300 tooltip"
                    title="Currency switch">
                    <span class="w-5 h-5 flex items-center justify-center">
                        <?php echo e(activeCurrencySymbol()); ?>

                    </span>
                </button>

                <div class="dropdown-box currency-box">
                    <div class="dropdown-box__content box dark:bg-dark-1 p-2">
                        <?php $__currentLoopData = \App\Models\Currency::where('is_published', 1)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <a href="<?php echo e(route('currencies.change')); ?>"
                                class="block p-2 transition duration-300 ease-in-out bg-white dark:bg-dark-1 hover:bg-gray-200 dark:hover:bg-dark-2 rounded-md"
                                onclick="event.preventDefault();
                                               document.getElementById('<?php echo e($item->code); ?>').submit()">

                                <?php echo e(Str::ucfirst($item->symbol . ' ' . $item->code)); ?>


                                <form id="<?php echo e($item->code); ?>" class="d-none" action="<?php echo e(route('currencies.change')); ?>"
                                    method="POST">
                                    <?php echo csrf_field(); ?>
                                    <input type="hidden" name="id" value="<?php echo e($item->id); ?>">
                                </form>
                            </a>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </div>

                </div>
            </div>
        </div>

        <!-- END: Currency -->


        <!-- BEGIN: Language -->
        <div class="intro-x relative mr-3 sm:mr-6 md:hidden">
            

            
            <div class="dropdown">

                <button
                    class="dropdown-toggle button px-2 mr-1 mb-2 border text-gray-700 dark:bg-dark-5 dark:text-gray-300 tooltip"
                    title="Language switch">
                    <span class="w-6 h-5 flex items-center justify-center">
                        <img src="<?php echo e(filePath('uploads/lang/' . countryFlag())); ?>" class="" height="30px"
                            alt="" />
                    </span>
                </button>

                <div class="dropdown-box lang-box">
                    <div class="dropdown-box__content dropdown-box__lang box dark:bg-dark-1 p-2">
                        <?php $__empty_1 = true; $__currentLoopData = languages(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <a href="<?php echo e(route('language.default', $language->id)); ?>"
                                class="block p-2 transition duration-300 ease-in-out bg-white dark:bg-dark-1 hover:bg-gray-200 dark:hover:bg-dark-2 rounded-md">
                                <img alt="<?php echo e($language->name); ?>" class="tooltip w-12 rounded m-auto"
                                    src="<?php echo e(flag($language->image)); ?>" title="<?php echo e($language->name); ?>">
                            </a>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <a href="javscript:;"
                                class="block p-2 transition duration-300 ease-in-out bg-white dark:bg-dark-1 hover:bg-gray-200 dark:hover:bg-dark-2 rounded-md">No language created</a>
                        <?php endif; ?>

                    </div>

                </div>
            </div>
        </div>
        <!-- END: Language -->


        <!-- BEGIN: Notifications -->

        <div class="intro-x dropdown mr-auto sm:mr-6">
            <div class="dropdown-toggle notification

        <?php echo e(unreadNotifications() > 0 ? 'notification--bullet' : ''); ?>


        cursor-pointer tooltip"
                title="Notifications">
                <i data-feather="bell" class="notification__icon dark:text-gray-300"></i>
            </div>
            <div class="notification-content pt-2 dropdown-box">
                <div class="notification-content__box dropdown-box__content box dark:bg-dark-6">
                    <div class="flex justify-between">
                        <div class="notification-content__title">
                            <a href="<?php echo e(route('notifications.index')); ?>">
                                See All Notifications
                            </a>
                        </div>
                        <div class="notification-content__title">
                            <form action="<?php echo e(route('markRead.notifications')); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <button type="submit">
                                    Marked as all read
                                </button>
                            </form>
                        </div>
                    </div>



                    <?php $__empty_1 = true; $__currentLoopData = notifications(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <div class="cursor-pointer relative flex items-center <?php echo e($key ? 'mt-5' : ''); ?>">
                            <div class="w-12 h-12 flex-none image-fit mr-1">
                                <img alt="Maildoll" class="rounded-full" src="<?php echo e(commonAvatar($notification->message)); ?>">
                                <div
                                    class="w-3 h-3 bg-theme-9 absolute right-0 bottom-0 rounded-full border-2 border-white">
                                </div>
                            </div>
                            <div class="ml-2 overflow-hidden">
                                <div class="flex items-center">
                                    <a href="<?php echo e($notification->link ?? 'javascript:;'); ?>"
                                        class="font-medium mr-5"><?php echo e($notification->message); ?></a>
                                </div>
                                <div class="w-full truncate text-gray-600"><?php echo e($notification->created_at->diffForHumans()); ?>

                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <div class="intro-y">
                            <div class="px-4 py-4 mb-3 flex items-center">

                                <img src="<?php echo e(notFound('no-notification.png')); ?>" class="m-auto no-shadow"
                                    alt="#campaign-not-found">

                            </div>
                        </div>
                    <?php endif; ?>




                </div>
            </div>
        </div>


        <!-- END: Notifications -->
        <!-- BEGIN: Account Menu -->
        <div class="intro-x dropdown w-8 h-8">
            <div class="dropdown-toggle w-8 h-8 rounded-full overflow-hidden shadow-lg image-fit zoom-in tooltip"
                title="<?php echo e(username()); ?>">
                <img src="<?php echo e(avatar()); ?>" />
            </div>
            <div class="dropdown-box w-56">
                <div class="dropdown-box__content box bg-theme-38 dark:bg-dark-6 text-white">
                    <div class="p-4 border-b border-theme-40 dark:border-dark-3">
                        <div class="font-medium"><?php echo e(username()); ?></div>
                        <div class="text-xs text-theme-41 dark:text-gray-600"><?php echo e(Auth::user()->user_type); ?></div>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Admin')): ?>
                            <div class="text-xs text-theme-42 dark:text-gray-700">Balance: $<?php echo e(totalEarned()); ?>

                            </div>
                        <?php endif; ?>
                    </div>
                    <div class="p-2">
                        <a href="<?php echo e(route('profile.index')); ?>"
                            class="flex items-center block p-2 transition duration-300 ease-in-out hover:bg-theme-1 dark:hover:bg-dark-3 rounded-md">
                            <i data-feather="user" class="w-4 h-4 mr-2"></i> Profile
                        </a>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('admin')): ?>
                            <?php if(env('SAAS_ACTIVE') == 'NO'): ?>
                                <a href="<?php echo e(route('limit.index')); ?>"
                                    class="flex items-center block p-2 transition duration-300 ease-in-out hover:bg-theme-1 dark:hover:bg-dark-3 rounded-md">
                                    <i data-feather="edit" class="w-4 h-4 mr-2"></i> Add Account
                                </a>
                            <?php endif; ?>
                        <?php endif; ?>

                        <a href="<?php echo e(route('profile.change.password')); ?>"
                            class="flex items-center block p-2 transition duration-300 ease-in-out hover:bg-theme-1 dark:hover:bg-dark-3 rounded-md">
                            <i data-feather="lock" class="w-4 h-4 mr-2"></i> Reset Password
                        </a>


                        

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Admin')): ?>
                            <?php if(env('SAAS_ACTIVE') == 'NO'): ?>
                                <a href="https://maildoll.gitbook.io/maildoll-email-and-sms-marketing-application"
                                    target="_blank"
                                    class="flex items-center block p-2 transition duration-300 ease-in-out hover:bg-theme-1 dark:hover:bg-dark-3 rounded-md">
                                    <i data-feather="book-open" class="w-4 h-4 mr-2"></i> Documentation
                                </a>

                                <a href="<?php echo e(route('help')); ?>" target="_blank"
                                    class="flex items-center block p-2 transition duration-300 ease-in-out hover:bg-theme-1 dark:hover:bg-dark-3 rounded-md">
                                    <i data-feather="help-circle" class="w-4 h-4 mr-2"></i> Help
                                </a>

                                <a href="https://youtube.com/playlist?list=PLPqwPhMH_hborEIPb4nGWWNEdOQz2k6ml" target="_blank"
                                    class="flex items-center block p-2 transition duration-300 ease-in-out hover:bg-theme-1 dark:hover:bg-dark-3 rounded-md">
                                    <i data-feather="help-circle" class="w-4 h-4 mr-2"></i> Tutorial
                                </a>
                            <?php endif; ?>
                        <?php endif; ?>



                    </div>
                    <div class="p-2 border-t border-theme-40 dark:border-dark-3">
                        <form action="<?php echo e(route('logout')); ?>" method="post">
                            <?php echo csrf_field(); ?>
                            <button type="submit" style="width:100%;"
                                class="flex items-center block p-2 transition duration-300 ease-in-out hover:bg-theme-1 dark:hover:bg-dark-3 rounded-md">
                                <i data-feather="toggle-right" class="w-4 h-4 mr-2"></i> Logout
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <!-- END: Account Menu -->
    </div>
    <!-- END: Top Bar -->


    

    <input type="hidden" value="<?php echo e(route('queue.work')); ?>" id="queue_work_url">
    <input type="hidden" value="<?php echo e(route('queue.retry')); ?>" id="queue_retry_url">
    <script src="<?php echo e(filePath('bladejs/top-bar.js')); ?>"></script>

<?php endif; ?>
<?php /**PATH /home/tanbir/office/maildoll/resources/views////layout/components/top-bar.blade.php ENDPATH**/ ?>