<section class="space-3 bg-primary-3">
    <div class="container rounded-lg">
        <div class="w-100 w-lg-75 text-center mx-auto mb-5 text-white">
            <h2 class="font-weight-bold text-center editable is-modified" data-cid="31" tabindex="1">
                <?php echo e(argonContent(31) ?? 'Choose the plan type that works best for you.'); ?></h2>
            <p class="lead mb-0 editable is-modified" data-cid="32" tabindex="1">
                <?php echo e(argonContent(32) ?? 'Choose the plan type that works best for you. No matter how you collect data, Maildoll pricing is simple, transparent and adapts to the size of your company.'); ?>

            </p>
        </div>
        <div class="row justify-content-center">
            <div class="col-lg-7">

                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Admin')): ?>

                <div class="avatar-upload">
                    <div class="avatar-edit">
                        <input type='file' id="imageUpload6" accept=".png, .jpg, .jpeg" />
                        <label for="imageUpload6"></label>
                    </div>
                    <div class="avatar-preview w-706 h-530">
                        <div id="imagePreview6" class="liveImagePreview6" data-img="img6"
                            style="background-image: url(<?php echo e(argonImagePath(argonContent('img6')) ?? filePath('frontend/argon/assets/img/illustration-5.svg')); ?>);">
                        </div>
                    </div>
                </div>

                <?php else: ?>
                <img class="img-fluid m-auto"
                    src="<?php echo e(argonContent('img6') != null ? argonImagePath(argonContent('img6')) : filePath('frontend/argon/assets/img/illustration-5.svg')); ?>"
                    alt="Illustartion">

                <?php endif; ?>


            </div>
        </div>
        <div class="row" id="pricing">

            <?php $__empty_1 = true; $__currentLoopData = displaySubscriptions(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plans): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="col-lg-4 mb-4 mb-lg-0 text-white mt-3">
                <div class="card card-body bg-white px-4 py-4 hover-translate-y hover-shadow">
                    <h2 class="font-weight-bold"><?php echo e(Str::upper($plans->name)); ?></h2>
                    <p class="lead"><?php echo e(strip_tags($plans->description)); ?></p>
                    <div class="d-flex align-items-center my-3">
                        <h4 class="h2"><?php echo e(formatPrice($plans->price)); ?></h4>
                        <p class="mt-2 ml-2"><?php echo e(Str::upper($plans->name)); ?></p>
                    </div>
                    <ul class="list-unstyled">
                        <li class="d-flex align-items-center mb-3">
                            <i class="ri-check-fill ri-xl text-white mr-2"></i>
                            <span><?php echo e($plans->duration); ?> Months</span>
                        </li>
                        <li class="d-flex align-items-center mb-3">
                            <i class="ri-check-fill ri-xl text-white mr-2"></i>
                            <span><?php echo e($plans->emails); ?> Emails</span>
                        </li>
                        <li class="d-flex align-items-center mb-3">
                            <i class="ri-check-fill ri-xl text-white mr-2"></i>
                            <span><?php echo e($plans->sms); ?> SMS</span>
                        </li>
                    </ul>
                    <a href="<?php echo e(route('payment.index', $plans)); ?>"
                        class="btn btn-primary editable is-modified" data-cid="33"
                        tabindex="1"><?php echo e(argonContent(33) ?? 'Select'); ?></a>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            
            <?php endif; ?>

        </div>
    </div>
</section>
<?php /**PATH /home/tanbir/office/maildoll/resources/views/frontend/argon/components/section5.blade.php ENDPATH**/ ?>