<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class InvoiceMail extends Mailable {
    use Queueable, SerializesModels;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public $details;

    public function __construct($details) {
        $this->details = $details;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build() {
        $invoice = $this->details->invoice;

        return $this->view('success.invoice')
            ->with('details')
            ->attach(asset('invoice_pdf/'.$invoice.'.pdf'), [
                'mime' => 'application/pdf',
            ]);
    }
}
